/*
 * Decompiled with CFR 0.152.
 */
package reliquary.client.init;

import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import reliquary.init.ModItems;
import reliquary.items.BulletItem;
import reliquary.items.MobCharmFragmentItem;
import reliquary.items.MobCharmItem;
import reliquary.items.VoidTearItem;
import reliquary.items.util.IPotionItem;
import reliquary.util.NBTHelper;

@OnlyIn(value=Dist.CLIENT)
public class ModItemColors {
    private ModItemColors() {
    }

    public static void init() {
        ItemColors itemColors = Minecraft.m_91087_().getItemColors();
        ModItemColors.registerMobCharmItemColors();
        ModItemColors.registerBulletItemColors();
        ModItemColors.registerPotionItemColors();
        ModItemColors.registerVoidTearItemColors(itemColors);
    }

    private static void registerVoidTearItemColors(ItemColors itemColors) {
        ModItemColors.registerItemColor((stack, tintIndex) -> {
            ItemStack containedStack;
            if (Screen.m_96638_() && !(containedStack = VoidTearItem.getTearContents(stack, true)).m_41619_()) {
                return itemColors.m_92676_(containedStack, tintIndex);
            }
            return -1;
        }, (Item)ModItems.VOID_TEAR.get());
    }

    private static void registerPotionItemColors() {
        ModItemColors.registerItemColor((stack, tintIndex) -> ModItemColors.getColor(stack), (Item)ModItems.POTION_ESSENCE.get());
        ModItemColors.registerItemColor((stack, tintIndex) -> {
            if (tintIndex == 1) {
                if (NBTHelper.getInt("renderColor", stack) > 0) {
                    return NBTHelper.getInt("renderColor", stack);
                }
                List<MobEffectInstance> effects = ((IPotionItem)stack.m_41720_()).getEffects(stack);
                if (effects.isEmpty()) {
                    return -1;
                }
                return PotionUtils.m_43564_(effects);
            }
            return -1;
        }, (Item)ModItems.POTION.get(), (Item)ModItems.SPLASH_POTION.get(), (Item)ModItems.LINGERING_POTION.get());
        ModItemColors.registerItemColor((stack, tintIndex) -> tintIndex == 0 ? PotionUtils.m_43564_(((IPotionItem)stack.m_41720_()).getEffects(stack)) : -1, (Item)ModItems.TIPPED_ARROW.get());
    }

    private static void registerBulletItemColors() {
        ModItemColors.registerItemColor((stack, tintIndex) -> {
            if (tintIndex == 0) {
                return -1;
            }
            if (tintIndex == 1) {
                return ((BulletItem)stack.m_41720_()).getColor();
            }
            if (tintIndex == 2) {
                return PotionUtils.m_43564_(((IPotionItem)stack.m_41720_()).getEffects(stack));
            }
            return -1;
        }, (Item)ModItems.EMPTY_MAGAZINE.get(), (Item)ModItems.NEUTRAL_MAGAZINE.get(), (Item)ModItems.EXORCISM_MAGAZINE.get(), (Item)ModItems.BLAZE_MAGAZINE.get(), (Item)ModItems.ENDER_MAGAZINE.get(), (Item)ModItems.CONCUSSIVE_MAGAZINE.get(), (Item)ModItems.BUSTER_MAGAZINE.get(), (Item)ModItems.SEEKER_MAGAZINE.get(), (Item)ModItems.SAND_MAGAZINE.get(), (Item)ModItems.STORM_MAGAZINE.get(), (Item)ModItems.EMPTY_BULLET.get(), (Item)ModItems.NEUTRAL_BULLET.get(), (Item)ModItems.EXORCISM_BULLET.get(), (Item)ModItems.BLAZE_BULLET.get(), (Item)ModItems.ENDER_BULLET.get(), (Item)ModItems.CONCUSSIVE_BULLET.get(), (Item)ModItems.BUSTER_BULLET.get(), (Item)ModItems.SEEKER_BULLET.get(), (Item)ModItems.SAND_BULLET.get(), (Item)ModItems.STORM_BULLET.get());
    }

    private static void registerMobCharmItemColors() {
        ModItemColors.registerItemColor((stack, tintIndex) -> {
            if (tintIndex < 1 || tintIndex > 2) {
                return -1;
            }
            ResourceLocation entityName = MobCharmItem.getEntityEggRegistryName(stack);
            return ModItemColors.getEgg(entityName).map(egg -> tintIndex == 1 ? egg.m_43211_(0) : egg.m_43211_(1)).orElse(-1);
        }, (Item)ModItems.MOB_CHARM.get());
        ModItemColors.registerItemColor((stack, tintIndex) -> {
            if (tintIndex < 0 || tintIndex > 1) {
                return -1;
            }
            ResourceLocation entityName = MobCharmFragmentItem.getEntityEggRegistryName(stack);
            return ModItemColors.getEgg(entityName).map(egg -> tintIndex == 0 ? egg.m_43211_(0) : egg.m_43211_(1)).orElse(-1);
        }, (Item)ModItems.MOB_CHARM_FRAGMENT.get());
    }

    private static void registerItemColor(ItemColor itemColor, Item ... items) {
        if (ModItems.isEnabled(items)) {
            Minecraft.m_91087_().getItemColors().m_92689_(itemColor, (ItemLike[])items);
        }
    }

    private static Optional<SpawnEggItem> getEgg(ResourceLocation entityName) {
        return Optional.ofNullable(SpawnEggItem.m_43213_((EntityType)((EntityType)ForgeRegistries.ENTITIES.getValue(entityName))));
    }

    private static int getColor(ItemStack stack) {
        return PotionUtils.m_43564_(((IPotionItem)stack.m_41720_()).getEffects(stack));
    }
}

